﻿using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Xml.Linq;
using System.Xml.Schema;
using System.Xml.Serialization;
using VIMT.VideoVisit.Services.Configuration;
using VRM.Integration.Servicebus.Core;
using XmlSerializer = System.Xml.Serialization.XmlSerializer;

namespace VIMT.VideoVisit.Services.XSD
{
    public static class AppointmentValidator
    {
        public static string ValidateCreateAppointment(Appointment appointment)
        {
            var serialized = SerializeInstance(appointment, new List<string> { "p" }, new List<string> { VideoVisitSecurityConfiguration.Current.SchemaNamespace });

            Logger.Instance.Debug("************ START VVS ************");
            Logger.Instance.Debug(serialized);
            Logger.Instance.Debug("************* END VVS *************");

            return ValidateSchema("Video Visit Service - Create",
                    VideoVisitSecurityConfiguration.Current.SchemaPath,
                    new List<string> { VideoVisitSecurityConfiguration.Current.SchemaNamespace },
                    new List<string> { "Appointment.xsd" },
                    serialized);
        }

        public static string ValidateCancelAppointment(CancelAppointmentRequest appointment)
        {
            var serialized = SerializeInstance(appointment, new List<string> { "p" }, new List<string> { VideoVisitSecurityConfiguration.Current.SchemaNamespace });

            Logger.Instance.Debug("************ START VVS ************");
            Logger.Instance.Debug(serialized);
            Logger.Instance.Debug("************* END VVS *************");

            return ValidateSchema("Video Visit Service - Delete",
                    VideoVisitSecurityConfiguration.Current.SchemaPath,
                    new List<string> { VideoVisitSecurityConfiguration.Current.SchemaNamespace },
                    new List<string> { "Appointment.xsd" },
                    serialized);
        }

        private static string SerializeInstance<T>(T classInstance, List<string> prefixes, List<string> namespaces)
        {
            using (var stream = new MemoryStream())
            {
                var serializer = new XmlSerializer(typeof(T));

                var ns = new XmlSerializerNamespaces();

                for (var i = 0; i < prefixes.Count; i++)
                {
                    ns.Add(prefixes[i], namespaces[i]);
                }

                serializer.Serialize(stream, classInstance, ns);
                return Encoding.ASCII.GetString(stream.ToArray());
            }
        }

        private static string ValidateSchema(string area, string schemaPath, List<string> namespaces, List<string> schemaFileNames, string xml)
        {
            var schemas = new XmlSchemaSet();

            for (var i = 0; i < namespaces.Count; i++)
            {
                schemas.Add(namespaces[i], Path.Combine(schemaPath, schemaFileNames[i]));
            }

            var examStatusUpdateXml = XDocument.Parse(xml);
            var schemaValidationMessage = string.Empty;
            examStatusUpdateXml.Validate(schemas, (o, err) => { schemaValidationMessage = err.Message; });

            return string.IsNullOrEmpty(schemaValidationMessage) ? null : string.Format("{0} Schema Validation Error: {1}", area, schemaValidationMessage);
        }
    }
}